inputDirectory = 'D:/Manuscripts/Chapter 3 - Fivash et al. 2020 Annals of Botany/Figure S7 & S8/CSV/'
setwd(inputDirectory)

d = read.csv('Figure S7 - Sediment water content.csv')
d = d[d$depth.cm != -1,] 

# ---------------- Figure S6: Water content at depth ------------ #

# plotDirectory = '/Users/gfivash/Desktop/'
# setwd(plotDirectory)
# tiff("Figure S6.tif",
#      width = 6, height = 6, 
#      units = 'in', res = 300)


d$pot.ID = factor(d$pot.ID)
for(i_pot in 1:length(unique(levels(d$pot.ID)))){
  filter = d$pot.ID == levels(d$pot.ID)[i_pot]
  
  d$depth.cm[filter] = d$depth.cm[filter] - min(d$depth.cm[filter]) + 1
}

d$depth.cm = factor(d$depth.cm)
d$lense = factor(d$lense, levels = c('flat','hollow','hummock'))
levels(d$lense) =  c('Flat','Lowered','Raised')
d$lense = factor(d$lense, levels = c('Lowered','Flat','Raised'))
color = alpha(c('yellow','green','blue'),0.5)
for(i_lense in 1:3){
  filter = d$lense == levels(d$lense)[i_lense]
  
  if(i_lense == 1){
  plot(d$water_content.percent[filter] ~ d$depth.cm[filter], ylim = c(10,60),
       col = color[i_lense], pch = '', xaxt = 'n',
       ylab = 'Sediment water content (%)', xlab = 'Depth range (cm)')
    axis(side = 1, at = 1:5, labels = c('0-1','1-2','2-3','3-4','4-5'))
  } else {
    plot(d$water_content.percent[filter] ~ d$depth.cm[filter], ylim = c(20,50),
         col = color[i_lense], add = T, xaxt = 'n', yaxt = 'n', pch = '')
  }
  points(d$water_content.percent[filter] ~ jitter(as.numeric(d$depth.cm[filter]),amount = 0.05), 
         ylim = c(20,50),
       pch = 21, bg = color[i_lense])
}
legend('topright', fill = color, legend = levels(d$lense), bty = 'n')

i_depth = 1
filter = d$depth.cm == levels(d$depth.cm)[i_depth]
m = aov(d$water_content.percent[filter] ~ d$lense[filter])
anova(m)
TukeyHSD(m)

d$depthGroup = d$depth.cm == 1
d$depthGroup = factor(as.numeric(d$depthGroup))
filter = d$depth.cm != 1
m = lm(d$water_content.percent[filter] ~ d$depth.cm[filter])
summary(m)

m = aov(d$water_content.percent[filter] ~ d$lense[filter] + 0)
anova(m)
TukeyHSD(m)


length(d$water_content.percent[d$depth.cm != 1 & d$lense == 'Lowered'])

# dev.off()

# ---------------- Figure S5: Water content ------------ #
# plotDirectory = '/Users/gfivash/Desktop/'
# setwd(plotDirectory)
# tiff("Figure S5.tif",
#      width = 7, height = 6, 
#      units = 'in', res = 300)

d = d[d$depth.cm == 1,] 

d$drainage = factor(d$drainage, levels = c('no drainage', 'drainage'))
levels(d$drainage) = c('No drainage', 'Drainage')
plot(c(1) ~ c(1), xlim = c(0.5,6.5), ylim = c(10,60), xaxt = 'n', yaxt = 'n', bty = 'n',
     ylab = 'Sediment water content (%)', xlab = 'Sediment shape')
rect(xleft = 0.5, xright = 3.5, ybottom = 10, ytop = 60, col = alpha('blue',0.2), lty = 0)
boxplot(d$water_content.percent ~ d$lense + d$drainage, col = color,
        ylim = c(10,60), xaxt = 'n', add = T)
axis(side = 1, line = 0, tick = T, at = 1:6,labels = rep(levels(d$lense), 2))
#axis(side = 1, line = 2, tick = F, at = c(2,5),labels = levels(d$drainage))
text(levels(d$drainage), x = c(2,5), y = c(15,15))

counter = 1
for(i_drainage in 1:length(levels(d$drainage))){
  for(i_lense in 1:length(levels(d$lense))){
    filter = d$lense == levels(d$lense)[i_lense] & d$drainage == levels(d$drainage)[i_drainage]
    y = d$water_content.percent[filter]
    x = jitter(rep(counter, times = length(y)), amount = 0.05)
    points(y ~ x, pch = 21, bg = color[i_lense])
    counter = counter + 1
  }
}

m = aov(d$water_content.percent ~ d$lense * d$drainage * d$inundation.percent)
anova(m)

m = aov(d$water_content.percent ~ d$lense * d$drainage)
anova(m)
TukeyHSD(m)
text(c('A','B','B','C','B','B'), x = 1:6, y = 56)


# Reporting comparison values in text (Sediment surface):
meanLowered = mean(d$water_content.percent[d$lense == 'Lowered'])
sdLowered = sd(d$water_content.percent[d$lense == 'Lowered'])/sqrt(42)
paste(round(meanLowered,2), '', round(sdLowered,2))
meanNotLowered = mean(d$water_content.percent[d$lense != 'Lowered'])
sdNotLowered = sd(d$water_content.percent[d$lense != 'Lowered'])/sqrt(42*2)
paste(round(meanNotLowered,2), '', round(sdNotLowered,2))

percentDiff = (meanLowered/meanNotLowered - 1) * 100

deviationLowered.perc = abs(d$water_content.percent[d$lense == 'Lowered'] - meanLowered)/meanLowered * 100
deviationNotLowered.perc = abs(d$water_content.percent[d$lense != 'Lowered'] - meanNotLowered)/meanNotLowered * 100
meanDeviation.perc = mean(c(deviationNotLowered.perc/sqrt(42*2), deviationLowered.perc/sqrt(42)))

paste(round(percentDiff,2), '', round(meanDeviation.perc,2))

# Reporting comparison values in text (Drainage):
meanDrained = mean(d$water_content.percent[d$drainage == 'Drainage'])
sdDrained = sd(d$water_content.percent[d$drainage == 'No drainage'])
paste(round(meanDrained,2), '', round(sdDrained,2))
meanNotDrained = mean(d$water_content.percent[d$lense != 'Drained'])
sdNotDrained = sd(d$water_content.percent[d$lense != 'Drained'])
paste(round(meanNotDrained,2), '', round(sdNotDrained,2))


deviationDrained = abs(d$water_content.percent[d$lense == 'Drained'] - meanDrained)/sqrt(63)
deviationNotDrained = abs(d$water_content.percent[d$lense != 'Drained'] - meanNotDrained)/sqrt(63)
meanDeviation = mean(c(deviationNotDrained, deviationDrained))

paste(round(meanNotDrained - meanDrained,2), '', round(meanDeviation,2))

# dev.off()
